/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.listener.uddi.inquiry_v2.uddi_org;

import filenet.vw.api.VWException;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.base.logging.Logger;
import java.util.Date;

public class WSWorkflowServiceInfo {
    protected static final Logger logger = Logger.getLogger("filenet.ws.listener.uddi");
    protected static final String m_className = "WSWorkflowServiceInfo";
    private String m_baseURL = null;
    private String m_cpName = null;
    private VWWorkflowSignature m_signature = null;
    private int m_isolatedRegion = -1;
    private String m_operator = null;
    private String m_authorizedName = "PE";

    public static String _get_FILE_DATE() {
        return "$Date:   29 Jun 2007 01:47:12  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.2  $";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WSWorkflowServiceInfo(VWWorkflowSignature signature, String baseURL, int region, String authorizedName, String operator, String cpName) throws VWException {
        String m_method = "Ctor";
        try {
            logger.entering(m_className, m_method);
            this.m_signature = signature;
            this.m_baseURL = baseURL;
            this.m_cpName = cpName;
            this.m_isolatedRegion = region;
            this.m_operator = operator;
            this.m_authorizedName = authorizedName;
            if (this.m_signature == null) {
                throw new VWException("filenet.ws.listener.uddi.nullWorkflowSignature", "Workflow signature is null");
            }
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    public VWWorkflowSignature getWorkflowSignature() {
        return this.m_signature;
    }

    public String getBaseURL() {
        return this.m_baseURL;
    }

    public int getIsolatedRegion() {
        return this.m_isolatedRegion;
    }

    public String getAuthorizedName() {
        return this.m_authorizedName;
    }

    public String getOperator() {
        return this.m_operator;
    }

    public String getDescription() {
        return this.m_signature.getDescription().trim();
    }

    public String getName() {
        return this.m_signature.getName().trim();
    }

    public Date getTransferDateTime() {
        return this.m_signature.getTransferDateTime();
    }

    public boolean getVersionAgnostic() {
        return this.m_signature.getVersionAgnostic();
    }

    public int getWorkspaceId() {
        return this.m_signature.getWorkspaceId();
    }

    public String getConnectionPointName() {
        return this.m_cpName;
    }
}

